/*
 * Decompiled with CFR 0.152.
 */
package com.Tarock.Common.Domain;

import java.util.ArrayList;
import java.util.List;

public class Round {
    private final int firstPlayer;
    private final List<Integer> cards;
    private int playerThatWon = -1;

    public Round(int firstPlayer) {
        this.firstPlayer = firstPlayer;
        this.cards = new ArrayList<Integer>();
        for (int i = 0; i < 4; ++i) {
            this.cards.add(0);
        }
    }

    public void addCard(int player, int cardID) {
        this.cards.set(player, cardID);
    }

    public int getCard(int player) {
        return this.cards.get(player);
    }

    public static boolean isTarock(int cardID) {
        return cardID >= 1 && cardID <= 22;
    }

    public static boolean isType(int cardID, int type) {
        return cardID >= 23 + type * 8 && cardID <= 30 + type * 8;
    }

    public int getCardType(int cardID) {
        int type = cardID - 23;
        return type / 8;
    }

    public void caseAreTarocks() {
        int i;
        int numberOfTrullCards = 0;
        for (i = 0; i < 4; ++i) {
            if (this.cards.get(i) != 1 && this.cards.get(i) != 21 && this.cards.get(i) != 22) continue;
            ++numberOfTrullCards;
        }
        if (numberOfTrullCards == 3) {
            for (i = 0; i < 4; ++i) {
                if (this.cards.get(i) != 1) continue;
                this.playerThatWon = i;
            }
        } else {
            int max = -1;
            for (int i2 = 0; i2 < 4; ++i2) {
                if (!Round.isTarock(this.cards.get(i2)) || max >= this.cards.get(i2)) continue;
                max = this.cards.get(i2);
                this.playerThatWon = i2;
            }
        }
    }

    public void calculateWinner() {
        if (Round.isTarock(this.cards.get(this.firstPlayer))) {
            this.caseAreTarocks();
        } else {
            int type = this.getCardType(this.cards.get(this.firstPlayer));
            for (int i = 0; i < 4; ++i) {
                if (!Round.isTarock(this.cards.get(i))) continue;
                this.caseAreTarocks();
                return;
            }
            int max = -1;
            for (int i = 0; i < 4; ++i) {
                if (!Round.isType(this.cards.get(i), type) || max >= this.cards.get(i)) continue;
                max = this.cards.get(i);
                this.playerThatWon = i;
            }
        }
    }

    public int getPlayerThatWon() {
        this.calculateWinner();
        return this.playerThatWon;
    }

    public int getFirstPlayer() {
        return this.firstPlayer;
    }

    public List<Integer> getCards() {
        return this.cards;
    }

    public void setPlayerThatWon(int playerThatWon) {
        this.playerThatWon = playerThatWon;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Round)) {
            return false;
        }
        Round other = (Round)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFirstPlayer() != other.getFirstPlayer()) {
            return false;
        }
        if (this.getPlayerThatWon() != other.getPlayerThatWon()) {
            return false;
        }
        List<Integer> this$cards = this.getCards();
        List<Integer> other$cards = other.getCards();
        return !(this$cards == null ? other$cards != null : !((Object)this$cards).equals(other$cards));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Round;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFirstPlayer();
        result = result * 59 + this.getPlayerThatWon();
        List<Integer> $cards = this.getCards();
        result = result * 59 + ($cards == null ? 43 : ((Object)$cards).hashCode());
        return result;
    }

    public String toString() {
        return "Round(firstPlayer=" + this.getFirstPlayer() + ", cards=" + this.getCards() + ", playerThatWon=" + this.getPlayerThatWon() + ")";
    }
}

