/*
 * Decompiled with CFR 0.152.
 */
package com.Tarock.Server.Service;

import com.Tarock.Common.Domain.Session;
import com.Tarock.Common.Domain.Triple;
import com.Tarock.Common.Domain.User;
import com.Tarock.Common.Exception.ConnectionException;
import com.Tarock.Common.Exception.LoginException;
import com.Tarock.Common.Exception.PHPException;
import com.Tarock.Common.Service.DataManipulationService;
import com.Tarock.Server.ConnectionManager.PHPConnection;
import com.Tarock.Server.GUI.StatusForm;
import com.Tarock.Server.Main;
import com.Tarock.Server.Service.CommunicationService;
import com.Tarock.Server.Service.GameSessionService;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class ClientService
extends Thread {
    public Socket socket;
    public ObjectInputStream inputStream;
    public ObjectOutputStream outputStream;
    public String username = null;
    public User savedUser = null;

    public ClientService(Socket socket) throws IOException {
        this.socket = socket;
        this.outputStream = new ObjectOutputStream(socket.getOutputStream());
        this.inputStream = new ObjectInputStream(socket.getInputStream());
    }

    public void removeConnection(String username) {
        for (int i = 0; i < CommunicationService.socketsList.size(); ++i) {
            if (!CommunicationService.socketsList.get(i).getKey().equals(username)) continue;
            try {
                CommunicationService.socketsList.get((int)i).getValue1().socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            CommunicationService.socketsList.remove(i);
            if (Main.noGUI) {
                System.out.println("Removed client " + username);
                continue;
            }
            StatusForm.addToStatusTextArea("Removed client " + username);
        }
    }

    public void addClientToList(ClientService clientService, String username, Session session) {
        Triple<String, ClientService, Session> newTriple = new Triple<String, ClientService, Session>(username, clientService, session);
        this.removeConnection(username);
        if (Main.noGUI) {
            System.out.println("Added client " + username);
        } else {
            StatusForm.addToStatusTextArea("Added client " + username);
        }
        CommunicationService.socketsList.add(newTriple);
    }

    public ClientService getClientInList(String username) {
        for (int i = 0; i < CommunicationService.socketsList.size(); ++i) {
            if (!CommunicationService.socketsList.get(i).getKey().equals(username)) continue;
            return CommunicationService.socketsList.get(i).getValue1();
        }
        return null;
    }

    public Session getSessionInList(String username) {
        for (int i = 0; i < CommunicationService.socketsList.size(); ++i) {
            if (!CommunicationService.socketsList.get(i).getKey().equals(username)) continue;
            return CommunicationService.socketsList.get(i).getValue2();
        }
        return null;
    }

    public void logSent(String message) {
        String processedMessage = message;
        if (message.startsWith("car")) {
            processedMessage = "sentCards;";
        }
        if (message.startsWith("encrypted")) {
            processedMessage = "sentPasswordForVerification;";
        }
        String finalMessage = "Sent (" + this.username + ") : " + processedMessage;
        if (Main.noGUI) {
            System.out.println(finalMessage);
        } else {
            StatusForm.addToStatusTextArea(finalMessage);
        }
    }

    public void logReceived(String message) {
        if (Main.noGUI) {
            System.out.println("Received (" + this.username + ") : " + message);
        } else {
            StatusForm.addToStatusTextArea("Received (" + this.username + ") : " + message);
        }
    }

    public void closeSession(EOFException exception) {
        Session session = this.getSessionInList(this.username);
        if (Main.noGUI) {
            System.out.println(exception.getMessage());
        } else {
            StatusForm.addToStatusTextArea(exception.getMessage());
        }
        for (GameSessionService gameSession : CommunicationService.gameSessions) {
            if (gameSession.session.getSessionID() != session.getSessionID()) continue;
            gameSession.stop();
            CommunicationService.gameSessions.remove(gameSession);
        }
    }

    public List<String> write(String sendMessage) throws IOException, ClassNotFoundException {
        this.logSent(sendMessage);
        String message = "";
        try {
            this.outputStream.writeObject(sendMessage);
            message = (String)this.inputStream.readObject();
        }
        catch (EOFException exception) {
            this.socket.close();
            this.closeSession(exception);
            Thread.currentThread().stop();
        }
        if (!message.equals("ok;")) {
            this.logReceived(message);
        }
        return DataManipulationService.processMessage(message);
    }

    public int getChairNumber(Session session, String username) {
        int chair = -1;
        if (session.getPlayer1().equals(username)) {
            chair = 0;
        } else if (session.getPlayer2().equals(username)) {
            chair = 1;
        } else if (session.getPlayer3().equals(username)) {
            chair = 2;
        } else if (session.getPlayer4().equals(username)) {
            chair = 3;
        }
        return chair;
    }

    public void runGame(Session session) throws IOException, ClassNotFoundException {
        User user;
        ArrayList<User> users = new ArrayList<User>();
        if (!CommunicationService.savedUsers.containsKey(session.getPlayer1())) {
            user = PHPConnection.getUser(session.getPlayer1());
            CommunicationService.savedUsers.put(session.getPlayer1(), user);
        }
        if (!CommunicationService.savedUsers.containsKey(session.getPlayer2())) {
            user = PHPConnection.getUser(session.getPlayer2());
            CommunicationService.savedUsers.put(session.getPlayer2(), user);
        }
        if (!CommunicationService.savedUsers.containsKey(session.getPlayer3())) {
            user = PHPConnection.getUser(session.getPlayer3());
            CommunicationService.savedUsers.put(session.getPlayer3(), user);
        }
        if (!CommunicationService.savedUsers.containsKey(session.getPlayer4())) {
            user = PHPConnection.getUser(session.getPlayer4());
            CommunicationService.savedUsers.put(session.getPlayer4(), user);
        }
        users.add(CommunicationService.savedUsers.get(session.getPlayer1()));
        users.add(CommunicationService.savedUsers.get(session.getPlayer2()));
        users.add(CommunicationService.savedUsers.get(session.getPlayer3()));
        users.add(CommunicationService.savedUsers.get(session.getPlayer4()));
        List<String> players = List.of(((User)users.get(0)).getName(), ((User)users.get(1)).getName(), ((User)users.get(2)).getName(), ((User)users.get(3)).getName());
        List<String> playersUsername = List.of(((User)users.get(0)).getUsername(), ((User)users.get(1)).getUsername(), ((User)users.get(2)).getUsername(), ((User)users.get(3)).getUsername());
        StringBuilder message = new StringBuilder("players");
        for (int i = 0; i < 4; ++i) {
            message.append(" ").append(players.get(i));
        }
        message.append(";");
        this.write(message.toString());
        this.getClientInList(this.username).write("chairNumber " + this.getChairNumber(session, this.username) + ";");
        boolean startGameSession = true;
        for (int i = 0; i < 4; ++i) {
            if (this.getClientInList(playersUsername.get(i)) == null) {
                startGameSession = false;
                continue;
            }
            if (this.getSessionInList(playersUsername.get(i)).getSessionID() == session.getSessionID()) continue;
            startGameSession = false;
        }
        if (startGameSession) {
            ArrayList<ClientService> clientServiceList = new ArrayList<ClientService>();
            for (int i = 0; i < 4; ++i) {
                clientServiceList.add(this.getClientInList(playersUsername.get(i)));
            }
            GameSessionService newGameService = new GameSessionService(clientServiceList, session, players);
            CommunicationService.gameSessions.add(newGameService);
            newGameService.start();
        }
    }

    public void authSession(int sessionID) throws IOException, ClassNotFoundException {
        try {
            Session session;
            if (!CommunicationService.savedSessions.containsKey(sessionID)) {
                session = PHPConnection.getSession(sessionID);
                CommunicationService.savedSessions.put(session.getSessionID(), session);
            }
            if (!((session = CommunicationService.savedSessions.get(sessionID)).getPlayer1().equals(this.username) || session.getPlayer2().equals(this.username) || session.getPlayer3().equals(this.username) || session.getPlayer4().equals(this.username))) {
                throw new PHPException("Session does not include " + this.username);
            }
            if (!session.getDateClosed().equals("")) {
                throw new ConnectionException("Session already ended !");
            }
            this.write("successful_auth;");
            this.addClientToList(this, this.username, session);
            this.runGame(session);
        }
        catch (PHPException exception) {
            this.write("failed_auth sessionID;");
            List<String> listOfCommands = this.write("require_auth;");
            this.runAuthentication(listOfCommands);
        }
        catch (ConnectionException exception) {
            this.write("failed_auth sessionIDEnded;");
            List<String> listOfCommands = this.write("require_auth;");
            this.runAuthentication(listOfCommands);
        }
    }

    public void authPassword(int sessionID) throws IOException, ClassNotFoundException {
        try {
            if (!CommunicationService.savedUsers.containsKey(this.username)) {
                CommunicationService.savedUsers.put(this.username, PHPConnection.getUser(this.username));
            }
            this.savedUser = CommunicationService.savedUsers.get(this.username);
        }
        catch (PHPException phpException) {
            throw new LoginException(phpException.getMessage());
        }
        String encryptedPassword = this.savedUser.getPassword();
        List<String> listOfCommands = this.write("encryptedPassword " + encryptedPassword + ";");
        List<String> listOfObjects = DataManipulationService.processCommand(listOfCommands.get(0));
        if (listOfObjects.get(0).equals("passwordOK")) {
            this.authSession(sessionID);
        } else {
            this.write("failed_auth password;");
            listOfCommands = this.write("require_auth;");
            this.runAuthentication(listOfCommands);
        }
    }

    public void authUsername(int sessionID) throws IOException, ClassNotFoundException {
        try {
            this.authPassword(sessionID);
        }
        catch (LoginException dbException) {
            this.write("failed_auth username;");
            List<String> listOfCommands = this.write("require_auth;");
            this.runAuthentication(listOfCommands);
        }
    }

    public void runAuthentication(List<String> listOfCommands) throws IOException, ClassNotFoundException {
        for (String listOfCommand : listOfCommands) {
            List<String> listOfObjects = DataManipulationService.processCommand(listOfCommand);
            if (listOfObjects.get(0).equals("auth")) {
                this.username = listOfObjects.get(1);
                int sessionID = Integer.parseInt(listOfObjects.get(2));
                this.authUsername(sessionID);
                continue;
            }
            throw new ConnectionException("Invalid authentication !");
        }
    }

    @Override
    public void run() {
        try {
            if (Main.noGUI) {
                System.out.println("Started thread");
            } else {
                StatusForm.addToStatusTextArea("Started thread");
            }
            List<String> listOfCommands = this.write("require_auth;");
            this.runAuthentication(listOfCommands);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

