/*
 * Decompiled with CFR 0.152.
 */
package com.Tarock.Common.Domain;

import com.Tarock.Common.Domain.ScoreAttribute;
import com.Tarock.Common.Service.DataManipulationService;
import java.util.ArrayList;
import java.util.List;

public class Score {
    private final List<ScoreAttribute> attributes = new ArrayList<ScoreAttribute>();
    private boolean isRadler = false;
    private String teamThatWon;

    public Score() {
        this.attributes.add(new ScoreAttribute(0, "Game", "", 2));
        this.attributes.add(new ScoreAttribute(1, "Pope at finish", "No", 0));
        this.attributes.add(new ScoreAttribute(2, "Pagat at finish", "No", 0));
        this.attributes.add(new ScoreAttribute(3, "All popes", "No", 0));
        this.attributes.add(new ScoreAttribute(4, "All trull cards", "No", 0));
        this.attributes.add(new ScoreAttribute(5, "Pope caught", "No", 0));
        this.attributes.add(new ScoreAttribute(6, "Luna caught", "No", 0));
        this.attributes.add(new ScoreAttribute(7, "Tarocks Player 01", "", 0));
        this.attributes.add(new ScoreAttribute(8, "Tarocks Player 02", "", 0));
        this.attributes.add(new ScoreAttribute(9, "Tarocks Player 03", "", 0));
        this.attributes.add(new ScoreAttribute(10, "Tarocks Player 04", "", 0));
        this.attributes.add(new ScoreAttribute(11, "Total", "", 0));
    }

    public String toString() {
        int i;
        StringBuilder string = new StringBuilder();
        for (i = 0; i < 12; ++i) {
            if (!string.toString().equals("")) {
                string.append(" ");
            }
            string.append(DataManipulationService.processName(this.getAttributeByID(i).getDeclaredOrDone()));
        }
        for (i = 0; i < 12; ++i) {
            string.append(" ").append(this.getAttributeByID(i).getPoints());
        }
        return string.toString();
    }

    public void computeTotal() {
        int total = 0;
        for (int i = 0; i < 11; ++i) {
            total += this.getAttributeByID(i).getPoints();
        }
        if (this.isRadler) {
            total *= 2;
            this.getAttribute("Total").setDeclaredOrDone("Radler");
        } else {
            this.getAttribute("Total").setDeclaredOrDone("Simple");
        }
        this.getAttribute("Total").setPoints(total);
    }

    public ScoreAttribute getAttributeByID(int ID) {
        for (ScoreAttribute attribute : this.attributes) {
            if (attribute.getID() != ID) continue;
            return attribute;
        }
        return null;
    }

    public ScoreAttribute getAttribute(String name) {
        for (ScoreAttribute attribute : this.attributes) {
            if (!attribute.getAttributeName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    public List<ScoreAttribute> getAttributes() {
        return this.attributes;
    }

    public boolean isRadler() {
        return this.isRadler;
    }

    public String getTeamThatWon() {
        return this.teamThatWon;
    }

    public void setRadler(boolean isRadler) {
        this.isRadler = isRadler;
    }

    public void setTeamThatWon(String teamThatWon) {
        this.teamThatWon = teamThatWon;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Score)) {
            return false;
        }
        Score other = (Score)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRadler() != other.isRadler()) {
            return false;
        }
        List<ScoreAttribute> this$attributes = this.getAttributes();
        List<ScoreAttribute> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        String this$teamThatWon = this.getTeamThatWon();
        String other$teamThatWon = other.getTeamThatWon();
        return !(this$teamThatWon == null ? other$teamThatWon != null : !this$teamThatWon.equals(other$teamThatWon));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Score;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRadler() ? 79 : 97);
        List<ScoreAttribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        String $teamThatWon = this.getTeamThatWon();
        result = result * 59 + ($teamThatWon == null ? 43 : $teamThatWon.hashCode());
        return result;
    }
}

