/*
 * Decompiled with CFR 0.152.
 */
package com.Tarock.Server.Service;

import com.Tarock.Common.Domain.Declaration;
import com.Tarock.Common.Domain.Game;
import com.Tarock.Common.Domain.Pair;
import com.Tarock.Common.Domain.Round;
import com.Tarock.Common.Domain.Score;
import com.Tarock.Common.Domain.ScoreComputationArguments;
import com.Tarock.Common.Domain.Session;
import com.Tarock.Common.Service.DataManipulationService;
import com.Tarock.Server.ConnectionManager.PHPConnection;
import com.Tarock.Server.Service.ClientService;
import com.Tarock.Server.Service.ScoreService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class GameSessionService
extends Thread {
    public List<ClientService> listOfClients;
    public Session session;
    public List<String> players;
    public int offsetGameNumber = -1;
    public int gameNumber = -1;
    public List<Integer> pope;
    public List<List<Integer>> cards;
    public List<List<List<Integer>>> teams;
    public List<List<List<Integer>>> cardsPlayers;
    public List<List<Integer>> talon;
    public List<List<List<Integer>>> cardsWon;
    public List<List<Round>> rounds;
    public List<List<String>> playersStatus;
    public List<List<Declaration>> declarations;
    public boolean showTeamsAfterTalonSelection = false;
    public boolean popeInTalon = false;
    public int radlerTimes = 0;
    public List<Integer> talonPart;
    public List<Integer> playerRequest;
    public List<Integer> the1of2;
    public List<Game> games;
    public List<Score> scores;
    public boolean neverInitializedGames = true;

    public GameSessionService(List<ClientService> listOfClients, Session session, List<String> players) {
        this.listOfClients = listOfClients;
        this.session = session;
        this.players = players;
        this.playersStatus = new ArrayList<List<String>>();
        this.cards = new ArrayList<List<Integer>>();
        this.cardsPlayers = new ArrayList<List<List<Integer>>>();
        this.talon = new ArrayList<List<Integer>>();
        this.declarations = new ArrayList<List<Declaration>>();
        this.teams = new ArrayList<List<List<Integer>>>();
        this.rounds = new ArrayList<List<Round>>();
        this.cardsWon = new ArrayList<List<List<Integer>>>();
        this.pope = new ArrayList<Integer>();
        this.talonPart = new ArrayList<Integer>();
        this.playerRequest = new ArrayList<Integer>();
        this.the1of2 = new ArrayList<Integer>();
        this.scores = new ArrayList<Score>();
    }

    public List<Integer> Cards() {
        return this.cards.get(this.gameNumber);
    }

    public List<List<Integer>> CardsWon() {
        return this.cardsWon.get(this.gameNumber);
    }

    public List<List<Integer>> CardsPlayers() {
        return this.cardsPlayers.get(this.gameNumber);
    }

    public Integer PlayerRequest() {
        return this.playerRequest.get(this.gameNumber);
    }

    public List<String> PlayerStatus() {
        return this.playersStatus.get(this.gameNumber);
    }

    public List<List<Integer>> Teams() {
        return this.teams.get(this.gameNumber);
    }

    public Integer Pope() {
        return this.pope.get(this.gameNumber);
    }

    public List<Integer> Talon() {
        return this.talon.get(this.gameNumber);
    }

    public Integer TalonPart() {
        return this.talonPart.get(this.gameNumber);
    }

    public Integer The1of2() {
        return this.the1of2.get(this.gameNumber);
    }

    public List<Declaration> Declarations() {
        return this.declarations.get(this.gameNumber);
    }

    public List<Round> Rounds() {
        return this.rounds.get(this.gameNumber);
    }

    public void sendAllPlayersWithoutPlayerRequest(String message) throws IOException, ClassNotFoundException {
        for (int i = 0; i < 4; ++i) {
            if (i == this.PlayerRequest()) continue;
            this.listOfClients.get(i).write(message);
        }
    }

    public void sendAllPlayers(String message) throws IOException, ClassNotFoundException {
        for (int i = 0; i < 4; ++i) {
            this.listOfClients.get(i).write(message);
        }
    }

    public List<String> sendPlayer(int player, String message) throws IOException, ClassNotFoundException {
        return this.listOfClients.get(player).write(message);
    }

    public List<String> getListOfObjectsFromPlayer(int player, String message) throws IOException, ClassNotFoundException {
        List<String> listOfCommands = this.sendPlayer(player, message);
        return DataManipulationService.processCommand(listOfCommands.get(0));
    }

    public void getAllPreviousGames() throws IOException, ClassNotFoundException {
        String creator = this.session.getCreator();
        this.games = PHPConnection.getGames(creator, this.session.getSessionID());
        this.offsetGameNumber = this.games.size();
        for (Game game : this.games) {
            this.sendAllPlayers(DataManipulationService.getScore(game));
        }
        if (this.games.size() > 0) {
            this.radlerTimes = this.games.get(this.games.size() - 1).getRadlerTimes();
        }
    }

    public int getNumberOf1of2Sent() {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            if (!this.PlayerStatus().get(i).equals("1/2")) continue;
            ++result;
        }
        return result;
    }

    public void computeTeams() {
        this.Teams().get(0).add(this.PlayerRequest());
        int playerThatHasPope = -1;
        block0: for (int i2 = 0; i2 < 4; ++i2) {
            for (Integer card : this.CardsPlayers().get(i2)) {
                if (card != 30 + this.Pope() * 8) continue;
                playerThatHasPope = i2;
                continue block0;
            }
        }
        if (playerThatHasPope != -1) {
            this.Teams().get(0).add(playerThatHasPope);
        }
        int finalPlayerThatHasPope = playerThatHasPope;
        IntStream.rangeClosed(0, 3).filter(i -> i != this.PlayerRequest() && i != finalPlayerThatHasPope).forEach(i -> this.Teams().get(1).add(i));
    }

    public void sendTeams() throws IOException, ClassNotFoundException {
        String message1 = DataManipulationService.getListOfInteger(this.Teams().get(0), "team1");
        String message2 = DataManipulationService.getListOfInteger(this.Teams().get(1), "team2");
        this.sendAllPlayers(message1 + message2);
    }

    public void talonSelectionRespondedNext() {
        for (int i = 0; i < 2; ++i) {
            if (this.Talon().get(this.TalonPart() * 2 + i) != 30 + this.Pope() * 8) continue;
            this.showTeamsAfterTalonSelection = true;
            break;
        }
        this.talonPart.set(this.gameNumber, this.TalonPart() + 1);
        this.the1of2.set(this.gameNumber, this.The1of2() + 1);
        this.talonPart.set(this.gameNumber, this.TalonPart() % 3);
    }

    public void attemptTalonSelection() throws IOException, ClassNotFoundException {
        boolean talonSelected = false;
        List<String> listOfObjects = this.getListOfObjectsFromPlayer(this.PlayerRequest(), "requestTalonSelection;");
        if (listOfObjects.get(0).equals("talonSelection")) {
            if (listOfObjects.get(1).equals("next")) {
                this.talonSelectionRespondedNext();
            } else if (listOfObjects.get(1).equals("take")) {
                talonSelected = true;
            }
            this.sendAllPlayersWithoutPlayerRequest("respondedTalonSelection " + listOfObjects.get(1) + ";");
        }
        if (!talonSelected) {
            this.attemptTalonSelection();
        }
    }

    public void replaceCardsPlayerRequest(int card1, int card2) {
        this.CardsWon().get(0).add(card1);
        this.CardsWon().get(0).add(card2);
        for (int i = 0; i < 2; ++i) {
            this.CardsPlayers().get(this.PlayerRequest()).add(this.Talon().get(this.TalonPart() * 2 + i));
        }
        this.CardsPlayers().get(this.PlayerRequest()).remove((Object)card1);
        this.CardsPlayers().get(this.PlayerRequest()).remove((Object)card2);
    }

    public void addRestOfTalonToCardsWonSecondTeam() {
        for (int i = 0; i < this.Talon().size(); ++i) {
            if (i == this.TalonPart() * 2 || i == this.TalonPart() * 2 + 1) continue;
            if (this.Talon().get(i) == 30 + this.Pope() * 8) {
                this.popeInTalon = true;
            }
            this.CardsWon().get(1).add(this.Talon().get(i));
        }
    }

    public void talonSelection() throws IOException, ClassNotFoundException {
        this.sendAllPlayers(DataManipulationService.getListOfInteger(this.Talon(), "talon"));
        this.sendAllPlayersWithoutPlayerRequest("requestedTalonSelection " + this.PlayerRequest() + ";");
        this.attemptTalonSelection();
        List<String> listOfObjects = this.getListOfObjectsFromPlayer(this.PlayerRequest(), "requestTalonReplacement;");
        if (listOfObjects.get(0).equals("talonReplacement")) {
            int card1 = Integer.parseInt(listOfObjects.get(1));
            int card2 = Integer.parseInt(listOfObjects.get(2));
            this.replaceCardsPlayerRequest(card1, card2);
            this.addRestOfTalonToCardsWonSecondTeam();
            Collections.sort(this.CardsPlayers().get(this.PlayerRequest()));
            this.computeTeams();
            if (this.showTeamsAfterTalonSelection) {
                this.sendTeams();
            }
            String message = DataManipulationService.getListOfInteger(this.CardsPlayers().get(this.PlayerRequest()), "cards");
            this.sendPlayer(this.PlayerRequest(), message);
        }
        this.sendAllPlayersWithoutPlayerRequest("closeTalonWindow show;");
        this.sendPlayer(this.PlayerRequest(), "closeTalonWindow select;");
    }

    public void requestPope() throws IOException, ClassNotFoundException {
        this.sendAllPlayers("requestedDeclaration " + this.PlayerRequest() + ";");
        List<String> listOfObjects = this.getListOfObjectsFromPlayer(this.PlayerRequest(), "requestPope;");
        if (listOfObjects.get(0).equals("pope")) {
            int pope = Integer.parseInt(listOfObjects.get(1));
            Declaration declaration = Declaration.builder().the1of2(0).popeAtFinish(false).pagatAtFinish(false).allPopes(false).trull(false).build();
            declaration.setPope(pope);
            declaration.setThe1of2(this.The1of2());
            this.Declarations().set(this.PlayerRequest(), declaration);
        }
        this.sendAllPlayers(DataManipulationService.getRespondedDeclaration(this.PlayerRequest(), this.Declarations()));
        this.sendAllPlayers("clearDeclarationTurn;");
    }

    public void requestDeclaration(int player) throws IOException, ClassNotFoundException {
        this.sendAllPlayers("requestedDeclaration " + player + ";");
        List<String> listOfObjects = this.getListOfObjectsFromPlayer(player, "requestDeclaration;");
        if (listOfObjects.get(0).equals("declaration")) {
            boolean popeAtFinish = DataManipulationService.stringToBool(listOfObjects.get(1));
            if (popeAtFinish) {
                this.sendTeams();
            }
            boolean pagatAtFinish = DataManipulationService.stringToBool(listOfObjects.get(2));
            boolean allPopes = DataManipulationService.stringToBool(listOfObjects.get(3));
            boolean trull = DataManipulationService.stringToBool(listOfObjects.get(4));
            int numberOfTarocks = Integer.parseInt(listOfObjects.get(5));
            Declaration declaration = Declaration.builder().popeAtFinish(popeAtFinish).pagatAtFinish(pagatAtFinish).allPopes(allPopes).trull(trull).numberOfTarocks(numberOfTarocks).build();
            if (player == this.PlayerRequest()) {
                int pope = this.Declarations().get(this.PlayerRequest()).getPope();
                declaration.setThe1of2(this.The1of2());
                declaration.setPope(pope);
            }
            this.Declarations().set(player, declaration);
        }
        this.sendAllPlayers(DataManipulationService.getRespondedDeclaration(player, this.Declarations()));
    }

    public void playerModeCancelOrRadler() throws IOException, ClassNotFoundException {
        this.playersStatus.remove(this.gameNumber);
        this.cards.remove(this.gameNumber);
        this.cardsPlayers.remove(this.gameNumber);
        this.declarations.remove(this.gameNumber);
        this.teams.remove(this.gameNumber);
        this.rounds.remove(this.gameNumber);
        this.cardsWon.remove(this.gameNumber);
        this.pope.remove(this.gameNumber);
        this.talonPart.remove(this.gameNumber);
        this.playerRequest.remove(this.gameNumber);
        this.the1of2.remove(this.gameNumber);
        --this.gameNumber;
        this.runHelper();
    }

    public void requestCard(int player, Round round) throws IOException, ClassNotFoundException {
        this.sendAllPlayers("requestedCard " + player + ";");
        List<String> listOfObjects = this.getListOfObjectsFromPlayer(player, "requestCard;");
        int cardGiven = -1;
        if (listOfObjects.get(0).equals("card")) {
            cardGiven = Integer.parseInt(listOfObjects.get(1));
            round.addCard(player, cardGiven);
        }
        this.sendAllPlayers("respondedCard " + player + " " + cardGiven + ";");
        if (cardGiven == 30 + this.Pope() * 8) {
            this.sendTeams();
        }
    }

    public void requestPlayerMode(int player) throws IOException, ClassNotFoundException {
        this.sendAllPlayers("requestedPlayerMode " + player + ";");
        List<String> listOfObjects = this.getListOfObjectsFromPlayer(player, "requestPlayerMode;");
        if (listOfObjects.get(1).equals("cancel")) {
            this.playerModeCancelOrRadler();
        }
        this.sendAllPlayers("respondedPlayerMode " + player + " " + listOfObjects.get(1) + ";");
        if (listOfObjects.get(0).equals("playerMode")) {
            this.PlayerStatus().set(player, listOfObjects.get(1));
            if (listOfObjects.get(1).equals("1/2")) {
                this.the1of2.set(this.gameNumber, this.The1of2() + 1);
                this.sendAllPlayers("increased1of2;");
            }
        }
    }

    public void doRound(int currentRound) throws IOException, ClassNotFoundException {
        int firstRequest = currentRound == 0 ? (this.gameNumber + this.offsetGameNumber) % 4 : this.Rounds().get(currentRound - 1).getPlayerThatWon();
        this.sendAllPlayers("beginRound;");
        Round round = new Round(firstRequest);
        for (int i = firstRequest; i < firstRequest + 4; ++i) {
            this.requestCard(i % 4, round);
        }
        this.Rounds().add(round);
        int playerThatWon = round.getPlayerThatWon();
        int teamThatWon = 1;
        for (Integer player : this.Teams().get(0)) {
            if (playerThatWon != player) continue;
            teamThatWon = 0;
            break;
        }
        for (int i = 0; i < 4; ++i) {
            this.CardsWon().get(teamThatWon).add(round.getCard(i));
        }
        this.sendAllPlayers("roundFinished;");
    }

    public void doRounds() throws IOException, ClassNotFoundException {
        for (int i = 0; i < 12; ++i) {
            this.doRound(i);
        }
        this.sendAllPlayers("showScoreWindow;");
        Collections.sort(this.CardsWon().get(0));
        Collections.sort(this.CardsWon().get(1));
        String message1 = DataManipulationService.getListOfInteger(this.CardsWon().get(0), "cardsTeam1");
        String message2 = DataManipulationService.getListOfInteger(this.CardsWon().get(1), "cardsTeam2");
        this.sendAllPlayers(message1 + message2);
    }

    public void computeScore() throws IOException, ClassNotFoundException {
        boolean isRadler = false;
        if (this.radlerTimes > 0) {
            isRadler = true;
            --this.radlerTimes;
        }
        ScoreComputationArguments scoreComputationArguments = new ScoreComputationArguments(this.PlayerRequest(), this.players, this.Teams(), this.Rounds(), this.Declarations(), this.CardsWon(), this.popeInTalon, isRadler);
        Pair<Game, Score> pair = ScoreService.getScore(scoreComputationArguments);
        Game game = pair.getKey();
        game.setRadlerTimes(this.radlerTimes);
        Score score = pair.getValue();
        if (this.games.size() > 0) {
            for (int i = 0; i < 4; ++i) {
                int previousScore = this.games.get(this.games.size() - 1).getScorePlayer(i);
                int totalScore = previousScore + game.getScorePlayer(i);
                game.setScorePlayer(i, totalScore);
            }
        }
        game.setSessionID(this.session.getSessionID());
        this.games.add(game);
        String creator = this.session.getCreator();
        PHPConnection.addGame(creator, game);
        this.scores.add(score);
        this.sendAllPlayers(DataManipulationService.getScore(game));
        this.sendAllPlayers(DataManipulationService.getScoreDetailed(score));
        this.runHelper();
    }

    public void initialization() throws IOException, ClassNotFoundException {
        int i;
        ++this.gameNumber;
        this.showTeamsAfterTalonSelection = false;
        this.popeInTalon = false;
        this.playersStatus.add(new ArrayList());
        this.cardsPlayers.add(new ArrayList());
        this.talon.add(new ArrayList());
        this.declarations.add(new ArrayList());
        this.teams.add(new ArrayList());
        this.rounds.add(new ArrayList());
        this.cardsWon.add(new ArrayList());
        this.pope.add(-1);
        this.talonPart.add(-1);
        this.playerRequest.add(-1);
        this.the1of2.add(1);
        for (i = 0; i < 2; ++i) {
            this.Teams().add(new ArrayList());
            this.CardsWon().add(new ArrayList());
        }
        for (i = 0; i < 4; ++i) {
            this.PlayerStatus().add("");
            this.Declarations().add(null);
            this.CardsPlayers().add(new ArrayList());
        }
        this.cards.add(IntStream.rangeClosed(1, 54).boxed().collect(Collectors.toList()));
        Collections.shuffle(this.Cards());
        int currentPlayer = 0;
        for (List<Integer> cardsPlayer : this.CardsPlayers()) {
            for (int i2 = 0; i2 < 12; ++i2) {
                cardsPlayer.add(this.Cards().get(currentPlayer * 12 + i2));
            }
            ++currentPlayer;
        }
        for (int j = 0; j < 6; ++j) {
            this.Talon().add(this.Cards().get(48 + j));
        }
        for (List<Integer> cardsPlayer : this.CardsPlayers()) {
            Collections.sort(cardsPlayer);
        }
        if (this.neverInitializedGames) {
            this.getAllPreviousGames();
            this.neverInitializedGames = false;
        }
    }

    public void runHelper() throws IOException, ClassNotFoundException {
        int i;
        this.initialization();
        int firstRequest = (this.gameNumber + this.offsetGameNumber) % 4;
        this.sendAllPlayers("beginGame;");
        for (i = 0; i < 4; ++i) {
            this.sendPlayer(i, DataManipulationService.getListOfInteger(this.CardsPlayers().get(i), "cards"));
        }
        for (i = firstRequest; i < firstRequest + 4; ++i) {
            this.requestPlayerMode(i % 4);
        }
        if (this.getNumberOf1of2Sent() == 0) {
            this.radlerTimes = 4;
            this.playerModeCancelOrRadler();
        }
        while (this.getNumberOf1of2Sent() > 1) {
            for (i = firstRequest; i < firstRequest + 4; ++i) {
                if (this.PlayerStatus().get(i % 4).equals("1/2")) {
                    this.requestPlayerMode(i % 4);
                }
                if (this.getNumberOf1of2Sent() != 1) continue;
                i = firstRequest + 4;
            }
        }
        for (i = 0; i < 4; ++i) {
            if (!this.PlayerStatus().get(i).equals("1/2")) continue;
            this.playerRequest.set(this.gameNumber, i);
        }
        this.the1of2.set(this.gameNumber, this.The1of2() - 1);
        this.talonPart.set(this.gameNumber, (this.The1of2() - 1) % 3);
        this.sendAllPlayers("playerRequest " + this.PlayerRequest() + " " + this.The1of2() + ";");
        this.requestPope();
        this.pope.set(this.gameNumber, this.Declarations().get(this.PlayerRequest()).getPope());
        this.talonSelection();
        for (i = firstRequest = this.PlayerRequest() % 4; i < firstRequest + 4; ++i) {
            this.requestDeclaration(i % 4);
        }
        this.sendAllPlayers("clearDeclarationTurn;");
        this.Declarations().get(this.PlayerRequest()).setThe1of2(this.The1of2());
        this.sendAllPlayers(DataManipulationService.getRespondedDeclaration(this.PlayerRequest(), this.Declarations()));
        this.doRounds();
        this.computeScore();
    }

    @Override
    public void run() {
        try {
            this.runHelper();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

